package nemosofts.voxradio.activity;

import android.content.Intent;
import android.os.Bundle;
import android.widget.TextView;

import androidx.activity.EdgeToEdge;
import androidx.nemosofts.AppCompatActivity;
import androidx.nemosofts.theme.ColorUtils;

import nemosofts.voxradio.BuildConfig;
import nemosofts.voxradio.R;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.dialog.DialogUtil;
import nemosofts.voxradio.utils.IfSupported;

public class DialogActivity extends AppCompatActivity {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        IfSupported.isRTL(this);
        IfSupported.isScreenshot(this);
        EdgeToEdge.enable(this);

        findViewById(R.id.rl_splash).setBackgroundColor(ColorUtils.colorBg(this));

        TextView appName = findViewById(R.id.tv_app_name);
        appName.setTextColor(ColorUtils.colorTitle(this));

        TextView appVersion = findViewById(R.id.tv_version);
        appVersion.setTextColor(ColorUtils.colorTitleSub(this));
        String version = getString(R.string.version) + " " + BuildConfig.VERSION_NAME;
        appVersion.setText(version);

        String from = getIntent().getStringExtra("from");
        if (from == null){
            openMainActivity();
        } else if (from.equals(Callback.DIALOG_TYPE_UPDATE)){
            DialogUtil.upgradeDialog(this, this::openMainActivity);
        } else if (from.equals(Callback.DIALOG_TYPE_MAINTENANCE)){
            DialogUtil.maintenanceDialog(this);
        } else if (from.equals(Callback.DIALOG_TYPE_DEVELOPER)){
            DialogUtil.dModeDialog(this);
        } else if (from.equals(Callback.DIALOG_TYPE_VPN)){
            DialogUtil.vpnDialog(this);
        } else {
            openMainActivity();
        }
    }

    @Override
    public int setContentViewID() {
        return R.layout.activity_launcher;
    }

    private void openMainActivity() {
        Intent intent = new Intent(DialogActivity.this, MainActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
        finish();
    }
}